/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.views;

import it.jrc.osint.analysis.ui.views.EntityTextAnnotation;
import it.jrc.osint.analysis.ui.views.EntityTextAnnotationFilter;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.Comparator;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class EntityTextAnnotationModel {
    private static final Logger log = LogManager.getLogger((String)EntityTextAnnotationModel.class.getName());
    private static final String TITLE_TEXT_SEPARATOR = ". ";
    public static final EntityTextAnnotationModel EMPTY_MODEL = new EntityTextAnnotationModel(0, 0);
    private NavigableMap<Integer, Set<EntityTextAnnotation>> annotationMap = new TreeMap<Integer, Set<EntityTextAnnotation>>();
    private Set<EntityTextAnnotationFilter> filterSet = new HashSet<EntityTextAnnotationFilter>();
    private int textLength;
    private int titleLength;

    public EntityTextAnnotationModel(int textLength, int titleLength) {
        this.textLength = textLength;
        this.titleLength = titleLength > 0 ? titleLength + TITLE_TEXT_SEPARATOR.length() : 0;
    }

    public void setFilterSet(Set<EntityTextAnnotationFilter> filterSet) {
        this.filterSet = filterSet;
    }

    public void add(EntityTextAnnotation anAnnotation) {
        if (this.insideTitle(anAnnotation)) {
            log.debug("Annotation " + anAnnotation.toString() + " inside title area, not added");
            return;
        }
        if (this.filterOut(anAnnotation)) {
            log.debug("Annotation " + anAnnotation.toString() + " filtered out.");
            return;
        }
        this.adjustCharPosToTitleLength(anAnnotation);
        if (this.insideText(anAnnotation)) {
            HashSet<EntityTextAnnotation> annotations = (HashSet<EntityTextAnnotation>)this.annotationMap.get(anAnnotation.getCharPos());
            if (annotations == null) {
                annotations = new HashSet<EntityTextAnnotation>();
                annotations.add(anAnnotation);
                this.annotationMap.put(anAnnotation.getCharPos(), annotations);
            } else {
                annotations.add(anAnnotation);
            }
        }
    }

    private boolean insideText(EntityTextAnnotation anAnnotation) {
        int charPos = anAnnotation.getCharPos();
        int length = anAnnotation.getLength();
        if (charPos > this.textLength) {
            log.error("Annotation of type " + anAnnotation.getType().toString() + " out of range, charPos > textSize");
            return false;
        }
        if (charPos + length > this.textLength) {
            log.error("Annotation of type " + anAnnotation.getType().toString() + " out of range, charPos + length > textSize");
            return false;
        }
        return true;
    }

    private boolean insideTitle(EntityTextAnnotation anAnnotation) {
        if (this.titleLength <= 0) {
            return false;
        }
        return anAnnotation.getCharPos() < this.titleLength - 1;
    }

    private void adjustCharPosToTitleLength(EntityTextAnnotation annotation) {
        int charPos;
        if (annotation == null) {
            return;
        }
        if (this.titleLength <= 0 && !"t".equals(annotation.getType())) {
            return;
        }
        int adjustedCharPos = charPos = annotation.getCharPos();
        adjustedCharPos = charPos < this.titleLength - 1 ? 0 : ("t".equals(annotation.getType()) && this.titleLength == 0 ? charPos - TITLE_TEXT_SEPARATOR.length() : charPos - this.titleLength);
        annotation.setCharPos(adjustedCharPos);
    }

    public void remove(EntityTextAnnotation anAnnotation) {
        Set annotations = (Set)this.annotationMap.get(anAnnotation.getCharPos());
        if (annotations.isEmpty()) {
            return;
        }
        annotations.remove(anAnnotation);
    }

    public Set<EntityTextAnnotation> getAll() {
        TreeSet<EntityTextAnnotation> resultSet = new TreeSet<EntityTextAnnotation>(new AnnotationComparator());
        for (Set annotations : this.annotationMap.values()) {
            resultSet.addAll(annotations);
        }
        return resultSet;
    }

    private boolean filterOut(EntityTextAnnotation anAnnotation) {
        for (EntityTextAnnotationFilter filter : this.filterSet) {
            if (!filter.filterOut(anAnnotation)) continue;
            return true;
        }
        return false;
    }

    public static String dump(EntityTextAnnotationModel aModel, String text) {
        StringBuffer strBuf = new StringBuffer();
        Set<EntityTextAnnotation> annotations = aModel.getAll();
        if (annotations.isEmpty()) {
            strBuf.append("\n");
        }
        for (EntityTextAnnotation anAnnotation : annotations) {
            strBuf.append(anAnnotation.toString());
            strBuf.append("\n");
        }
        return strBuf.toString();
    }

    private static class AnnotationComparator
    implements Comparator<EntityTextAnnotation> {
        private AnnotationComparator() {
        }

        @Override
        public int compare(EntityTextAnnotation ann1, EntityTextAnnotation ann2) {
            if (ann1.getCharPos() < ann2.getCharPos()) {
                return -1;
            }
            if (ann1.getCharPos() > ann2.getCharPos()) {
                return 1;
            }
            if (ann1.getLength() < ann2.getLength()) {
                return 1;
            }
            if (ann1.getLength() > ann2.getLength()) {
                return -1;
            }
            return 0;
        }
    }
}

