/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.views;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.ui.AnalysisUIEventImpl;
import it.jrc.osint.analysis.ui.views.EntityTreeViewerController;
import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.workspace.WorkspaceService;
import java.util.HashSet;
import java.util.Set;

public abstract class EntityTreeViewerControllerImpl
implements EntityTreeViewerController {
    private static final Logger log = LogManager.getLogger((String)EntityTreeViewerControllerImpl.class.getName());
    private WorkspaceService ws;
    private ExtractionService es;
    private EventBroker eb;

    public EntityTreeViewerControllerImpl(WorkspaceService ws, ExtractionService es, EventBroker eventBroker) {
        this.ws = ws;
        this.es = es;
        this.eb = eventBroker;
    }

    @Override
    public WorkspaceService getWorkspaceService() {
        return this.ws;
    }

    @Override
    public Set<ResourceId> getRelatedDocuments(Entity anEntity) {
        return this.getAnalysisDatamodel().getRelatedDocumentIds(anEntity);
    }

    @Override
    public boolean isShowRelatedEntitiesEnabled() {
        return false;
    }

    @Override
    public void showRelatedEntities(Entity anEntity) {
    }

    @Override
    public void addEntitiesToGraph(Set<Entity> entities) {
        AnalysisUIEventImpl event = new AnalysisUIEventImpl("osint/analysis/ui/addEntity", entities, this.getAnalysisDatamodel().getProjectId());
        this.eb.postEvent((SystemEvent)event);
    }

    @Override
    public int getEntityOccurrences(Entity anEntity) {
        return this.getAnalysisDatamodel().getEntityOccurrenceCount(anEntity);
    }

    @Override
    public int getEntityOccurrences(Entity anEntity, ResourceId docId) {
        return this.getAnalysisDatamodel().getEntityOccurrenceCount(anEntity, docId);
    }

    @Override
    public Set<EntityType> getEntityTypes() {
        HashSet<EntityType> typeSet = new HashSet<EntityType>();
        typeSet.addAll(this.es.getEntityTypes());
        return typeSet;
    }

    @Override
    public void openDocument(ResourceId id) {
        AnalysisUIEventImpl event = new AnalysisUIEventImpl("osint/analysis/ui/openDocumentViewer");
        event.setDocumentId(id);
        this.eb.postEvent((SystemEvent)event);
    }

    protected abstract AnalysisDatamodel getAnalysisDatamodel();
}

