/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.views;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.EntityContainer;
import it.jrc.osint.analysis.EntityContainerChangeListener;
import it.jrc.osint.analysis.relation.DocumentEntityRelation;
import it.jrc.osint.analysis.ui.AnalysisUIEventImpl;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.ui.PartListenerAdapter;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class RelatedDocumentsTreeView
extends ViewPart {
    public static final String VIEW_ID = "it.jrc.osint.analysis.ui.views.RelatedDocumentsView";
    private static final Logger log = LogManager.getLogger((String)RelatedDocumentsTreeView.class.getName());
    private TreeViewer treeViewer;
    private PartListenerImpl partListener;
    private EntityContainer entityContainer;
    private Map<String, DocumentEntitiesRelation> relatedDocumentsMap = new HashMap<String, DocumentEntitiesRelation>();
    private Set<Entity> entitySet = new HashSet<Entity>();
    private ResourceId projectId;
    private EntitySetChangeListenerImpl entitySetChangeListener = new EntitySetChangeListenerImpl();

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer(container, 0);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)RelatedDocumentsTreeView.this.treeViewer.getSelection();
                    TreeNode node = (TreeNode)selection.getFirstElement();
                    Object nodeValue = node.getValue();
                    if (nodeValue instanceof ResourceId) {
                        ResourceId docId = (ResourceId)nodeValue;
                        AnalysisUIPlugin.getEventBroker().postEvent((SystemEvent)new AnalysisUIEventImpl("osint/analysis/ui/openDocumentViewer", docId));
                    }
                }
                catch (Throwable t) {
                    log.error("Failed to open document view", t);
                }
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new EntityTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new EntityTreeLabelProvider());
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
        this.partListener = new PartListenerImpl();
        this.getSite().getPage().addPartListener((IPartListener)this.partListener);
        this.refresh(false);
    }

    private void createActions() {
    }

    private void initializeToolBar() {
    }

    private void initializeMenu() {
    }

    public void refresh(boolean forceReload) {
        log.debug("Refresh requested");
        IEditorPart editorPart = this.getSite().getPage().getActiveEditor();
        if (editorPart == null) {
            return;
        }
        EntityContainer entityContainer = (EntityContainer)editorPart.getAdapter(EntityContainer.class);
        if (entityContainer != null) {
            this.refreshData(entityContainer, forceReload);
        }
    }

    private void clearData() {
        if (this.entityContainer != null) {
            this.entityContainer.removeChangeListener((EntityContainerChangeListener)this.entitySetChangeListener);
        }
        this.entityContainer = null;
        this.entitySet.clear();
        this.relatedDocumentsMap.clear();
        this.treeViewer.setInput(null);
    }

    private void refreshData(EntityContainer esProvider, boolean forceReload) {
        if (esProvider == null) {
            return;
        }
        if (this.entityContainer != esProvider) {
            if (this.entityContainer != null) {
                this.entityContainer.removeChangeListener((EntityContainerChangeListener)this.entitySetChangeListener);
            }
            esProvider.addChangeListener((EntityContainerChangeListener)this.entitySetChangeListener);
        }
        this.entityContainer = esProvider;
        this.entitySet.clear();
        this.entitySet.addAll(esProvider.getEntities());
        this.projectId = esProvider.getProjectId();
        TreeNode rootNode = new TreeNode((Object)"Documents");
        AnalysisDatamodel adm = AnalysisUIPlugin.getAnalysisService().getAnalysisDatamodel(this.projectId, forceReload);
        if (adm.isNull()) {
            this.treeViewer.setInput((Object)rootNode);
        } else {
            this.calculateRelatedDocuments(this.entitySet, AnalysisUIPlugin.getAnalysisService(), adm);
            LinkedList<TreeNode> docNodesList = new LinkedList<TreeNode>();
            for (String docId : this.relatedDocumentsMap.keySet()) {
                DocumentEntitiesRelation docERel = this.relatedDocumentsMap.get(docId);
                TreeNode docNode = new TreeNode((Object)docERel.getDocumentId());
                Set<Entity> entitySet = docERel.getEntities();
                this.getEntitiesSubTree(docNode, entitySet);
                docNodesList.add(docNode);
            }
            TreeNode[] docNodes = null;
            if (!docNodesList.isEmpty()) {
                docNodes = docNodesList.toArray(new TreeNode[0]);
                rootNode.setChildren(docNodes);
            } else {
                rootNode = null;
            }
            this.treeViewer.setInput((Object)rootNode);
        }
    }

    private TreeNode getEntitiesSubTree(TreeNode rootNode, Set<Entity> entitySet) {
        HashMap<String, HashSet<Entity>> entityTypeMap = new HashMap<String, HashSet<Entity>>();
        for (Entity entity : entitySet) {
            if (entity == null) continue;
            String type = entity.getType();
            HashSet<Entity> typeEntitySet = (HashSet<Entity>)entityTypeMap.get(type);
            if (typeEntitySet == null) {
                typeEntitySet = new HashSet<Entity>();
                entityTypeMap.put(type, typeEntitySet);
            }
            typeEntitySet.add(entity);
        }
        LinkedList<TreeNode> typeNodes = new LinkedList<TreeNode>();
        ExtractionService es = AnalysisUIPlugin.getExtractionService();
        List entityTypeList = es.getEntityTypes();
        for (EntityType t : entityTypeList) {
            TreeNode typeNode = new TreeNode((Object)t);
            this.createSubTreeForType(typeNode, (Set)entityTypeMap.get(t), t);
            if (!typeNode.hasChildren()) continue;
            typeNodes.add(typeNode);
        }
        TreeNode[] entityTypeNodes = typeNodes.toArray(new TreeNode[0]);
        rootNode.setChildren(entityTypeNodes);
        return rootNode;
    }

    private void createSubTreeForType(TreeNode parent, Set<Entity> entitySet, EntityType entityType) {
        if (entitySet == null || entitySet.size() == 0) {
            return;
        }
        TreeNode[] childNodes = new TreeNode[entitySet.size()];
        int i = 0;
        for (Entity entity : entitySet) {
            TreeNode newEntityNode = new TreeNode((Object)entity);
            childNodes[i++] = newEntityNode;
        }
        parent.setChildren(childNodes);
    }

    private void calculateRelatedDocuments(Set<Entity> entitySet, AnalysisService as, AnalysisDatamodel ad) {
        this.relatedDocumentsMap.clear();
        for (Entity entity : entitySet) {
            Set relatedDocIds = ad.getRelatedDocumentIds(entity);
            for (ResourceId aDocId : relatedDocIds) {
                Set docRelations = as.getDocumentEntityRelations(aDocId);
                for (DocumentEntityRelation docRelation : docRelations) {
                    this.addEntityDocumentRelation(docRelation);
                }
            }
        }
    }

    private void addEntityDocumentRelation(DocumentEntityRelation edr) {
        DocumentEntitiesRelation der = this.relatedDocumentsMap.get(edr.getDocumentId());
        if (der == null) {
            der = new DocumentEntitiesRelation(edr.getDocumentId());
            this.relatedDocumentsMap.put(edr.getDocumentId(), der);
        }
        der.add(edr);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.treeViewer != null && this.treeViewer.getTree() != null) {
            this.treeViewer.getTree().dispose();
        }
        if (this.partListener != null) {
            this.getSite().getPage().removePartListener((IPartListener)this.partListener);
        }
        if (this.entityContainer != null) {
            this.entityContainer.removeChangeListener((EntityContainerChangeListener)this.entitySetChangeListener);
        }
    }

    private class DocumentEntitiesRelation {
        private String docId;
        private List<DocumentEntityRelation> entities = new ArrayList<DocumentEntityRelation>();

        public DocumentEntitiesRelation(String docId) {
            this.docId = docId;
        }

        public String getDocumentId() {
            return this.docId;
        }

        public void add(DocumentEntityRelation edr) {
            this.entities.add(edr);
        }

        public Set<Entity> getEntities() {
            HashSet<Entity> entitySet = new HashSet<Entity>();
            for (DocumentEntityRelation rel : this.entities) {
                entitySet.add(rel.getEntity());
            }
            return entitySet;
        }
    }

    private class EntitySetChangeListenerImpl
    implements EntityContainerChangeListener {
        private EntitySetChangeListenerImpl() {
        }

        public void entitiesChanged() {
            RelatedDocumentsTreeView.this.refreshData(RelatedDocumentsTreeView.this.entityContainer, false);
        }
    }

    private class EntityTreeContentProvider
    extends TreeNodeContentProvider {
        private EntityTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TreeNode) {
                TreeNode input = (TreeNode)inputElement;
                return input.getChildren();
            }
            return new Object[0];
        }
    }

    private class EntityTreeLabelProvider
    extends LabelProvider {
        private EntityTreeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof TreeNode) {
                Object value = ((TreeNode)element).getValue();
                if (value instanceof ResourceId) {
                    ResourceId resourceId = (ResourceId)value;
                    WorkspaceService ws = AnalysisUIPlugin.getWorkspaceService();
                    CaseProject cp = ws.getCaseProjectByDocumentId(resourceId);
                    DocumentMetaItem metaItem = cp.getMetaItem(resourceId);
                    if (metaItem != null) {
                        return metaItem.getTitle();
                    }
                } else {
                    return ((TreeNode)element).getValue().toString();
                }
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            try {
                if (element instanceof TreeNode) {
                    Object elementValue = ((TreeNode)element).getValue();
                    if (elementValue instanceof EntityType) {
                        EntityType type = (EntityType)elementValue;
                        String typeId = type.getId();
                        return AnalysisUIPlugin.getPlugin().getImageForEntityTypeId(typeId);
                    }
                    if (elementValue instanceof Entity) {
                        Entity entity = (Entity)elementValue;
                        String typeId = entity.getType();
                        return AnalysisUIPlugin.getPlugin().getImageForEntityTypeId(typeId);
                    }
                    if (elementValue instanceof ResourceId) {
                        return AnalysisUIPlugin.getPlugin().getImageRegistry().get("document");
                    }
                }
            }
            catch (Throwable t) {
                log.error("Problem in EntityTreeLabelProvider", t);
            }
            return null;
        }
    }

    private class PartListenerImpl
    extends PartListenerAdapter {
        private PartListenerImpl() {
        }

        protected boolean isEntityContainerPart(IWorkbenchPart part) {
            if (part == null) {
                return false;
            }
            return part.getAdapter(EntityContainer.class) != null;
        }

        public void partActivated(IWorkbenchPart part) {
            if (this.isEntityContainerPart(part) && RelatedDocumentsTreeView.this.entityContainer != part.getAdapter(EntityContainer.class)) {
                RelatedDocumentsTreeView.this.refreshData((EntityContainer)part.getAdapter(EntityContainer.class), false);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (this.isEntityContainerPart(part)) {
                if (RelatedDocumentsTreeView.this.entityContainer != part.getAdapter(EntityContainer.class)) {
                    RelatedDocumentsTreeView.this.refreshData((EntityContainer)part.getAdapter(EntityContainer.class), false);
                }
            } else {
                RelatedDocumentsTreeView.this.clearData();
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (this.isEntityContainerPart(part) && RelatedDocumentsTreeView.this.entityContainer == part.getAdapter(EntityContainer.class)) {
                RelatedDocumentsTreeView.this.clearData();
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (this.isEntityContainerPart(part) && RelatedDocumentsTreeView.this.getSite().getPage().isPartVisible(part)) {
                RelatedDocumentsTreeView.this.refreshData((EntityContainer)part.getAdapter(EntityContainer.class), false);
            }
        }
    }
}

