/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.views;

import it.jrc.osint.analysis.EntityContainer;
import it.jrc.osint.analysis.ui.views.EntityTreeViewer;
import it.jrc.osint.analysis.ui.views.RelatedEntitiesViewController;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.ui.PartListenerAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class RelatedEntitiesView
extends ViewPart {
    public static final String VIEW_ID = "it.jrc.osint.analysis.ui.views.RelatedEntitiesView";
    private static final Logger log = LogManager.getLogger((String)RelatedEntitiesView.class.getName());
    private PartListenerImpl partListener;
    private TreeViewer treeViewer;
    private EntityTreeViewer entityTreeViewer;
    private RelatedEntitiesViewController controller = new RelatedEntitiesViewController(this);
    private MenuManager menuMgr;

    public RelatedEntitiesView() {
        this.entityTreeViewer = new EntityTreeViewer(this.controller);
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.treeViewer = this.entityTreeViewer.createPartControl(container, this.getSite());
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.initializeToolBar();
        this.initializeMenu();
        this.partListener = new PartListenerImpl();
        this.getSite().getPage().addPartListener((IPartListener)this.partListener);
        this.refresh();
    }

    private void initializeMenu() {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RelatedEntitiesView.this.entityTreeViewer.fillContextMenu(manager);
                RelatedEntitiesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = this.menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        TreeNode tn;
        Object firstSelectedObject;
        IStructuredSelection ss = (IStructuredSelection)this.treeViewer.getSelection();
        if (ss == null || ss.isEmpty()) {
            return;
        }
        boolean multiSelection = false;
        if (ss.size() > 1) {
            multiSelection = true;
        }
        if ((firstSelectedObject = ss.getFirstElement()) instanceof TreeNode && (tn = (TreeNode)firstSelectedObject).getValue() instanceof Entity) {
            if (!multiSelection) {
                manager.add((IContributionItem)new Separator());
                IAction showEntityTextLocations = this.showEntityTextLocationAction((Entity)tn.getValue());
                manager.add(showEntityTextLocations);
            }
            manager.add((IContributionItem)new Separator());
            IAction showAllEntitiesTextLocationAction = this.showAllEntitiesTextLocationAction();
            manager.add(showAllEntitiesTextLocationAction);
        }
    }

    private IAction showEntityTextLocationAction(final Entity anEntity) {
        Action highlightEntityAction = new Action(){

            public void run() {
                try {
                    RelatedEntitiesView.this.controller.showEntityTextLocations(anEntity);
                }
                catch (Throwable t) {
                    log.error("Failed to highlight entity");
                }
            }
        };
        highlightEntityAction.setText("Show Text Locations");
        return highlightEntityAction;
    }

    private IAction showAllEntitiesTextLocationAction() {
        Action highlightEntityAction = new Action(){

            public void run() {
                try {
                    RelatedEntitiesView.this.controller.resetTextMarkup();
                }
                catch (Throwable t) {
                    log.error("Failed to highlight entity");
                }
            }
        };
        highlightEntityAction.setText("Show All Entities Text Locations");
        return highlightEntityAction;
    }

    private void initializeToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
    }

    EntityTreeViewer getEntityTreeViewer() {
        return this.entityTreeViewer;
    }

    public void refresh() {
        log.debug("Refresh requested");
        IEditorPart editorPart = this.getSite().getPage().getActiveEditor();
        if (editorPart == null) {
            return;
        }
        EntityContainer entityContainer = (EntityContainer)editorPart.getAdapter(EntityContainer.class);
        if (entityContainer != null) {
            this.controller.onRefreshData(entityContainer);
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    private class PartListenerImpl
    extends PartListenerAdapter {
        private PartListenerImpl() {
        }

        protected boolean isEntityContainerPart(IWorkbenchPart part) {
            if (part == null) {
                return false;
            }
            return part.getAdapter(EntityContainer.class) != null;
        }

        public void partActivated(IWorkbenchPart part) {
            if (this.isEntityContainerPart(part)) {
                EntityContainer partEntityContainer = (EntityContainer)part.getAdapter(EntityContainer.class);
                if (!RelatedEntitiesView.this.controller.isCurrentContainer(partEntityContainer)) {
                    RelatedEntitiesView.this.controller.onRefreshData(partEntityContainer);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (this.isEntityContainerPart(part) && !RelatedEntitiesView.this.controller.isCurrentContainer((EntityContainer)part.getAdapter(EntityContainer.class))) {
                RelatedEntitiesView.this.controller.onRefreshData((EntityContainer)part.getAdapter(EntityContainer.class));
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (this.isEntityContainerPart(part) && RelatedEntitiesView.this.controller.isCurrentContainer((EntityContainer)part.getAdapter(EntityContainer.class))) {
                RelatedEntitiesView.this.controller.onClearData();
            }
            if (this == part) {
                RelatedEntitiesView.this.getSite().getPage().removePartListener((IPartListener)RelatedEntitiesView.this.partListener);
                RelatedEntitiesView.this.controller.onViewClosed();
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (this.isEntityContainerPart(part) && RelatedEntitiesView.this.getSite().getPage().isPartVisible(part)) {
                RelatedEntitiesView.this.controller.onRefreshData((EntityContainer)part.getAdapter(EntityContainer.class));
            }
        }
    }
}

