/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.emmcrawler;

import it.jrc.emmcrawler.GetItems;
import it.jrc.emmcrawler.Href;
import it.jrc.emmcrawler.HrefManager;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.rss.RSSItem;
import java.util.ArrayList;

public abstract class Crawler
extends Thread {
    private static final boolean DEBUG = false;
    protected static Logger logger = null;
    protected HrefManager hrefManager;
    private ArrayList<GetItems> workers;
    private int nWait;
    protected int nWorkers;
    protected int nRandomDelay;
    protected String htmlType;
    protected int minTextSize;
    protected int maxDepth;
    private int nDone;
    protected String xHost;
    protected String source;
    public boolean bRunning;
    private boolean bFinished;
    private Object syncLock;

    public Crawler() {
        if (logger == null) {
            logger = LogManager.getLogger((String)"it.jrc.emmcrawler.Crawler");
        }
        this.nWait = 0;
        this.nDone = 0;
        this.nWorkers = 1;
        this.nRandomDelay = 0;
        this.minTextSize = 200;
        this.maxDepth = -1;
        this.workers = new ArrayList();
        this.xHost = null;
        this.source = null;
        this.htmlType = null;
        this.syncLock = new Object();
        this.bRunning = false;
        this.bFinished = false;
    }

    public Crawler(String url, int maxd, String follow) {
        this();
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(url);
        this.maxDepth = maxd;
        this.hrefManager = new HrefManager(urls, this.maxDepth, follow);
        logger.info("crawler constructed");
    }

    public Crawler(ArrayList<String> urls, int maxd, String follow) {
        this();
        this.maxDepth = maxd;
        this.hrefManager = new HrefManager(urls, this.maxDepth, follow);
        logger.info("crawler constructed");
    }

    public void setWorkers(int nWork) {
        this.nWorkers = nWork;
    }

    public void setXhost(String host) {
        this.xHost = host;
    }

    public void setMinTextSize(int min) {
        this.minTextSize = min;
    }

    public void setRandomDelay(int d) {
        this.nRandomDelay = d;
    }

    public void setSource(String s) {
        this.source = s;
    }

    public void setHtmlType(String t) {
        this.htmlType = t;
    }

    public int getMinTextSize() {
        return this.minTextSize;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public String getSource() {
        return this.source;
    }

    public synchronized Href getNext(Href hrefDone) {
        if (!this.bRunning) {
            return null;
        }
        Href href = this.hrefManager.getNext(hrefDone);
        if (href == null) {
            ++this.nWait;
            this.bRunning = this.nWait < this.nWorkers;
            while (href == null && this.bRunning) {
                try {
                    this.wait();
                    href = this.hrefManager.getNext();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.bRunning) {
                --this.nWait;
            }
        }
        return href;
    }

    public synchronized void putItem(RSSItem item) {
        if (item != null) {
            this.newItem(item);
            ArrayList hrefs = (ArrayList)item.getInfo();
            this.hrefManager.add(hrefs);
        }
        this.notifyAll();
    }

    public synchronized void failItem(Href href) {
        logger.info("failed " + href.url + " status:" + href.retCode);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void done() {
        logger.info("crawler done() called for " + this.source + " nDone = " + this.nDone);
        ++this.nDone;
        this.notifyAll();
        if (this.nDone == this.nWorkers) {
            this.finished();
            this.hrefManager.close();
            this.hrefManager = null;
            this.workers.clear();
            this.workers = null;
            this.bFinished = true;
            this.bRunning = false;
            Object object = this.syncLock;
            synchronized (object) {
                this.syncLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        logger.info("crawler sync");
        if (this.bFinished) {
            return;
        }
        Object object = this.syncLock;
        synchronized (object) {
            try {
                logger.info("have to wait");
                while (this.bRunning) {
                    this.syncLock.wait(5000L);
                }
                logger.info("sync done");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void cancel() {
        this.bRunning = false;
    }

    protected abstract void newItem(RSSItem var1);

    protected abstract void finished();

    public RSSItem checkItem(String url) {
        return null;
    }

    protected abstract boolean canExtract(String var1);

    @Override
    public synchronized void start() {
        this.bRunning = true;
        super.start();
    }

    @Override
    public void run() {
        logger.info("crawler start with " + this.nWorkers + " workers");
        this.bRunning = true;
        int i = 0;
        while (i < this.nWorkers) {
            GetItems getItems = new GetItems(this, i);
            getItems.setMinTextSize(this.minTextSize);
            getItems.setHtmlType(this.htmlType);
            getItems.setRandomDelay(this.nRandomDelay);
            if (this.xHost != null && !this.xHost.equals("")) {
                getItems.setXhostPattern(this.xHost);
            }
            if (this.source != null) {
                getItems.setSource(this.source);
            }
            this.workers.add(getItems);
            ++i;
        }
        for (GetItems w : this.workers) {
            w.start();
        }
    }
}

