/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.emmcrawler;

import it.jrc.emmutils.HTTPUrl;
import it.jrc.emmutils.Utils;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.rss.SimpleAttribute;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;

public class Href {
    public String title;
    public int confidence;
    public int level;
    public int xhost;
    public int count;
    public String url;
    public HTTPUrl httpUrl;
    public int type;
    public int retCode;
    private static Logger logger = null;

    public Href() {
        if (logger == null) {
            logger = LogManager.getLogger((String)"it.jrc.emmcrawler.Href");
        }
        this.title = null;
        this.confidence = 0;
        this.level = 0;
        this.xhost = 0;
        this.count = 0;
        this.url = null;
        this.httpUrl = null;
        this.type = -1;
    }

    public Href(String u) {
        this();
        this.httpUrl = new HTTPUrl(u);
        this.url = this.httpUrl.getUrl();
    }

    public Href(HTTPUrl baseUrl, String u) {
        this();
        this.httpUrl = new HTTPUrl(baseUrl, u);
        this.url = this.httpUrl.getUrl();
        if (this.httpUrl.isLocal(baseUrl)) {
            this.type = 1;
        } else if (!(this.url.startsWith("#") || this.url.startsWith("ftp://") || this.url.startsWith("javascript") || this.url.startsWith("mail") || this.url.startsWith("file://") || this.url.startsWith("skype:"))) {
            this.type = 2;
        }
    }

    public Href(Href org) {
        this();
        if (org != null) {
            this.title = org.title;
            this.confidence = org.confidence;
            this.level = org.level;
            this.xhost = org.xhost;
            this.url = org.url;
            this.httpUrl = org.httpUrl;
            this.type = org.type;
            this.count = org.count;
        }
    }

    public Href(SimpleElement elem) {
        this();
        ArrayList atts = elem.getAttributes();
        for (SimpleAttribute att : atts) {
            this.setProperty(att.name, att.value);
        }
        this.httpUrl = new HTTPUrl(this.url);
    }

    private void setProperty(String name, String value) {
        if (name.equals("title")) {
            this.title = value;
        } else if (name.equals("url")) {
            this.url = value;
        } else if (name.equals("level")) {
            try {
                this.level = new Integer(value);
            }
            catch (Exception exception) {}
        } else if (name.equals("refCount")) {
            try {
                this.count = new Integer(value);
            }
            catch (Exception exception) {}
        } else if (name.equals("xhost")) {
            try {
                this.xhost = new Integer(value);
            }
            catch (Exception exception) {}
        } else if (name.equals("confidence")) {
            try {
                this.confidence = new Integer(value);
            }
            catch (Exception exception) {}
        } else if (name.equals("type")) {
            try {
                this.type = new Integer(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isLocal() {
        return this.type == 1;
    }

    public boolean isRemote() {
        return this.type == 2;
    }

    public SimpleElement toElement() {
        SimpleElement elem = new SimpleElement("emm:href");
        elem.addAttribute("title", Utils.encodeXML((String)this.title));
        elem.addAttribute("url", Utils.encodeXML((String)this.url));
        elem.addAttribute("level", Integer.toString(this.level));
        elem.addAttribute("confidence", Integer.toString(this.confidence));
        elem.addAttribute("type", Integer.toString(this.type));
        elem.addAttribute("xhost", Integer.toString(this.xhost));
        elem.addAttribute("refCount", Integer.toString(this.count));
        elem.addAttribute("status", Integer.toString(this.retCode));
        return elem;
    }

    public String toString() {
        return "url=" + this.url + "; title=" + this.title + "; refCount=" + this.count + "; level=" + this.level + "; confidence=" + this.confidence + "; xhost=" + this.xhost + "; status=" + this.retCode;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<emm:href>");
        sb.append("<title>");
        if (this.title != null) {
            sb.append(Utils.encodeXML((String)this.title));
        }
        sb.append("</title>");
        sb.append("<url>" + Utils.encodeXML((String)this.url) + "</url>");
        sb.append("<level>" + this.level + "</level>");
        sb.append("<refCount>" + this.count + "</refCount>");
        sb.append("<confidence>" + this.confidence + "</confidence>");
        sb.append("<xhost>" + this.xhost + "</xhost>");
        sb.append("<type>" + this.type + "</type>");
        sb.append("<status>" + this.retCode + "</status>");
        sb.append("</emm:href>");
        return sb.toString();
    }
}

