/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.crawler.internal;

import it.jrc.osint.crawler.CrawlerConfiguration;
import it.jrc.osint.util.WorkspaceFileEditorModelImpl;
import it.jrc.osint.util.io.PersistentMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CrawlerConfigurationImpl
extends WorkspaceFileEditorModelImpl
implements CrawlerConfiguration {
    private static final long serialVersionUID = -6924910435961379684L;
    private static final int VERSION = 1;
    private static final String SITES = "sites";
    private static final String RANDOM_DELAY_MS = "randomDelayMs";
    private static final String MAX_DEPTH = "maxDepth";
    private static final String MIN_TEXT_SIZE = "minTextSize";
    private static final String WORKERS_PER_SITE = "workersPerSite";
    private static final String EXCLUDE_PATTERN = "excludePattern";
    private static final String INCLUDE_PATTERN = "includePattern";
    private PersistentMap map;

    CrawlerConfigurationImpl() {
        this.map = new PersistentMap("it.jrc.osint.contenttype.CrawlerConfig", 1);
        this.map.put(SITES, new ArrayList());
        this.map.put(RANDOM_DELAY_MS, (Object)2500);
        this.map.put(MAX_DEPTH, (Object)1);
        this.map.put(MIN_TEXT_SIZE, (Object)200);
        this.map.put(WORKERS_PER_SITE, (Object)1);
        this.map.put(EXCLUDE_PATTERN, (Object)"");
        this.map.put(INCLUDE_PATTERN, (Object)"");
    }

    CrawlerConfigurationImpl(PersistentMap map) {
        if (map.getVersion() < 1) {
            if (!map.containsKey((Object)EXCLUDE_PATTERN)) {
                map.put(EXCLUDE_PATTERN, (Object)"");
            }
            if (!map.containsKey((Object)INCLUDE_PATTERN)) {
                map.put(INCLUDE_PATTERN, (Object)"");
            }
            map.setVersion(1);
        }
        this.map = map;
    }

    @Override
    public void setExcludePattern(String pattern) {
        this.map.put(EXCLUDE_PATTERN, (Object)pattern);
        this.modelChanged();
    }

    @Override
    public String getExcludePattern() {
        return (String)this.map.get((Object)EXCLUDE_PATTERN);
    }

    @Override
    public void setIncludePattern(String pattern) {
        this.map.put(INCLUDE_PATTERN, (Object)pattern);
        this.modelChanged();
    }

    @Override
    public String getIncludePattern() {
        return (String)this.map.get((Object)INCLUDE_PATTERN);
    }

    @Override
    public void setRandomDelayMs(int randomDelayMs) {
        this.map.put(RANDOM_DELAY_MS, (Object)randomDelayMs);
        this.modelChanged();
    }

    @Override
    public int getRandomDelayMs() {
        return (Integer)this.map.get((Object)RANDOM_DELAY_MS);
    }

    @Override
    public void addSite(String site) {
        if (site == null || "".equals(site)) {
            return;
        }
        if (!this.hasSite(site.trim())) {
            this.getSites().add(site);
            this.modelChanged();
        }
    }

    private boolean hasSite(String site) {
        return this.getSites().contains(site);
    }

    @Override
    public void setSite(int index, String site) {
        this.getSites().set(index, site);
        this.modelChanged();
    }

    @Override
    public void removeSite(String site) {
        this.getSites().remove(site);
        this.modelChanged();
    }

    @Override
    public int getMaxDepth() {
        return (Integer)this.map.get((Object)MAX_DEPTH);
    }

    @Override
    public List<String> getSites() {
        return (List)this.map.get((Object)SITES);
    }

    @Override
    public String[] getSitesArray() {
        String[] sitesArray = new String[this.getSites().size()];
        sitesArray = this.getSites().toArray(sitesArray);
        return sitesArray;
    }

    @Override
    public int getWorkersPerSite() {
        return (Integer)this.map.get((Object)WORKERS_PER_SITE);
    }

    @Override
    public void setMaxDepth(int maxDepth) {
        this.map.put(MAX_DEPTH, (Object)maxDepth);
        this.modelChanged();
    }

    @Override
    public void setWorkersPerSite(int workersPerSite) {
        this.map.put(WORKERS_PER_SITE, (Object)workersPerSite);
        this.modelChanged();
    }

    protected Serializable getPersistenceObject() {
        return this.map;
    }
}

